	function hHP = LP_2_HP_FIR(hLP)
	
	% 	Generate the impulse response of the highpass filter for a lowpass FIR filter
	%	by changing the signs of every second coeffient such that the center 
	%	coeffient remains the same.
	
	% 	Toolbox for DIGITAL FILTERS USING MATLAB
	
	% 	Author: 		T. Saramki
	% 	Modified by: 	LW 2017-12-08	
	% 	Copyright:		by authors - not released for commercial use
	% 	Version:		1	 
	% 	Known bugs:		
	% 	Report bugs to:	Wanhammar@gmail.com
	
	N = length(hLP) -1;
	if mod(N,2) == 1
		disp(['Error  must be an even order FIR filter'])
		break
	end
	hHP = -hLP;	
	for n = rem(N/2,2)+1:2:N-rem(N/2,2)+1
	    hHP(n) = -hHP(n);	
	end		

		
